/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdmnetu;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.Icon;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdmnetu.ConfirmationBox;
import ibm.nways.jdmnetu.DeviceGraphicInfo;
import ibm.nways.jdmnetu.FastNetUModel;
import ibm.nways.jdmnetu.GraphicSlotContainer;
import ibm.nways.jdmnetu.StatusPipeNetUImpl;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class BoxGraphic {
    private GenModel systemModel;
    private GenModel interfaceModel;
    private JdmBrowser jdmNetUBrowser;
    private GraphicSlotContainer slotContainer;
    private static ResourceBundle jdmNetUBundle = null;
    private static final int RASID = 19;
    private static final int RASSUB = 17;
    private Thread getSlots;
    private Thread reCheckStatus;
    private static final String PropertiesFile = "properties/jdmNetU.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    private ModelInfo pciAdapInfo;
    private Icon statusIcon;
    GenModel jdmNetUmodel;
    private int[] slotTypes;
    Hashtable statusIndexes;

    protected BoxGraphic(JdmBrowser jdmBrowser) {
        this.jdmNetUBrowser = jdmBrowser;
    }

    protected GraphicPanel getGraphicPanel() {
        StringTokenizer stringTokenizer;
        String string;
        Properties properties;
        Serializable serializable;
        String string2 = "getGraphicPanel";
        GraphicContainer graphicContainer = new GraphicContainer();
        try {
            serializable = new URL(this.jdmNetUBrowser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            properties = null;
            RAS.logError(19, 17, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)PropertiesFile);
            RAS.logException(19, 17, this, string2, exception);
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdmNetUBrowser.getLayout();
        this.slotTypes = null;
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            if (RAS.isEnabled(19, 17)) {
                RAS.trace(19, 17, this, string2, "The layout scheme property is: " + serializable);
            }
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            string = (String)((Hashtable)properties).get(fractKey);
            stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logError(19, 17, this, string2, "EXCEPTION_CALCULATING_FRACTIONS");
                    RAS.logException(19, 17, this, string2, (Exception)numberFormatException);
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        if (jdmNetUBundle == null) {
            jdmNetUBundle = ResourceBundle.getBundle("ibm.nways.jdmnetu.Resources");
        }
        serializable = new Point(20, 20);
        string = null;
        try {
            this.systemModel = (GenModel)this.jdmNetUmodel.getComponent("System");
            string = new GraphicActionNavigate((GraphicHandler)this.jdmNetUBrowser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)this.systemModel), null);
        }
        catch (Exception exception) {
            RAS.logException(19, 17, this, string2, exception);
        }
        GraphicImage graphicImage = new GraphicImage(this.jdmNetUBrowser.imageFrom((Object)this, "jdmNetU.gif"), (Point)serializable, 3, (GraphicAction)string, null);
        graphicContainer.add((GraphicComponent)graphicImage);
        stringTokenizer = new GraphicHelp((BrowserApplet)this.jdmNetUBrowser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)stringTokenizer);
        this.slotContainer = new GraphicSlotContainer(this.jdmNetUBrowser, (Point)serializable);
        this.doGraphicsThread();
        graphicContainer.add((Component)((Object)this.slotContainer), 0);
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.jdmNetUBrowser, (Component)graphicContainer);
        return graphicPanel;
    }

    public void doGraphicsThread() {
        if (this.getSlots != null) {
            this.getSlots.stop();
        }
        String string = "doGraphicsThread";
        this.statusIndexes = new Hashtable(30);
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.jdmNetUmodel.getComponent("IbmNetUGraphic");
        }
        catch (Exception exception) {}
        if (RAS.isEnabled(19, 17)) {
            RAS.trace(19, 17, this, string, "ibmNetUGraphicModel = " + genModel);
        }
        this.getSlots = new GraphicsThread(genModel);
        this.getSlots.start();
    }

    private int[] getSlotTypes() {
        return this.slotTypes;
    }

    public void showSlotContainer() {
        if (this.slotContainer != null) {
            this.slotContainer.showCards();
        }
    }

    public void stopThreads() {
        if (this.getSlots != null && this.getSlots.isAlive()) {
            this.getSlots.stop();
        }
        if (this.reCheckStatus != null && this.reCheckStatus.isAlive()) {
            this.reCheckStatus.stop();
        }
        if (this.statusIcon != null) {
            this.jdmNetUBrowser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
        }
    }

    void predetermineAllSlots() {
        if (this.pciAdapInfo == null) {
            return;
        }
        String string = "predetermineAllSlots";
        try {
            this.slotTypes = new int[2];
            int n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.IbmNetUPCIAdapType1");
            int n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(1, n2);
            this.slotTypes[0] = n2;
            n = (Integer)this.pciAdapInfo.get("PciAdapGraphics.IbmNetUPCIAdapType2");
            n2 = this.mapPciSlotType(n);
            this.slotContainer.addSlot(2, n2);
            this.slotTypes[1] = n2;
            this.showSlotContainer();
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 17, this, string, "EXCEPTION_GETTING_MODELINFO", (Object)"PciAdapGraphics", (Object)"JdmNetUModel");
            RAS.logException(19, 17, this, string, exception);
            return;
        }
    }

    public void gotOne(DeviceGraphicInfo deviceGraphicInfo) {
        Integer n = new Integer(deviceGraphicInfo.index);
        this.statusIndexes.put(n, n);
        StatusAttachThread statusAttachThread = new StatusAttachThread(deviceGraphicInfo);
        statusAttachThread.start();
    }

    public void processOne(DeviceGraphicInfo deviceGraphicInfo) {
        StatusProxy statusProxy = new StatusProxy(deviceGraphicInfo.status);
        GraphicActionNavigate graphicActionNavigate = this.createGraphicAction(deviceGraphicInfo.index);
        int n = this.mapInterfaceSlotType(deviceGraphicInfo.type, deviceGraphicInfo.speed);
        this.slotContainer.addSlot(deviceGraphicInfo.slot, deviceGraphicInfo.port, statusProxy, graphicActionNavigate, n);
    }

    private GraphicActionNavigate createGraphicAction(int n) {
        try {
            if (this.interfaceModel == null) {
                this.interfaceModel = (GenModel)this.jdmNetUmodel.getComponent("Interface");
            }
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Index.IfIndex", new Integer(n));
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow((NavigationContext)navigationContext, (ModelInfo)modelInfo);
            navigationContext.setParent(this.jdmNetUBrowser.getNavigationTree().getNavContext());
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmNetUBrowser, new NavigationDestination("ibm.nways.mib2.eui.Mib2InterfacesPanel", (RemoteModel)this.interfaceModel), navigationContext);
            return graphicActionNavigate;
        }
        catch (Exception exception) {
            RAS.logException(19, 17, this, "CreateGraphicAction", exception);
            return null;
        }
    }

    private void attachStatusAndAction(GenModel genModel) {
        this.statusIcon = new Icon(this.jdmNetUBrowser.imageFrom((Object)this, "statusAnimation.gif"));
        this.statusIcon.setFlyOver(new GraphicFlyOver(jdmNetUBundle.getString("RetrievingStatus")));
        this.jdmNetUBrowser.addTrayIcon(this.statusIcon);
        Thread thread = null;
        try {
            Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
            int n = 0;
            while (n < vector.size()) {
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                IbmNetUGraphicAttachThread ibmNetUGraphicAttachThread = new IbmNetUGraphicAttachThread(modelInfo);
                ibmNetUGraphicAttachThread.start();
                thread = ibmNetUGraphicAttachThread;
                ++n;
            }
        }
        catch (Exception exception) {
            this.handleGraphicsError(exception);
        }
        try {
            if (thread != null) {
                thread.join();
            }
        }
        catch (Exception exception) {}
        this.jdmNetUBrowser.removeTrayIcon(this.statusIcon);
        this.statusIcon.getImage().flush();
        this.statusIcon = null;
    }

    private void ibmNetUGraphicAttach(ModelInfo modelInfo) {
        try {
            int n = (Integer)modelInfo.get("Index.IbmNetUGraphicSlotNum");
            int n2 = (Integer)modelInfo.get("Index.IbmNetUGraphicPortNum");
            int n3 = (Integer)modelInfo.get("Panel.IbmNetUGraphicifIndex");
            GraphicActionNavigate graphicActionNavigate = this.createGraphicAction(n3);
            ModelInfo modelInfo2 = new ModelInfo();
            modelInfo2.add("Index.IfIndex", new Integer(n3));
            RemoteStatus remoteStatus = this.interfaceModel.getStatusRefForRow(modelInfo2);
            StatusProxy statusProxy = new StatusProxy(remoteStatus);
            this.slotContainer.addSlot(n, n2, statusProxy, graphicActionNavigate, this.slotTypes[n - 1]);
            return;
        }
        catch (Exception exception) {
            this.handleGraphicsError(exception);
            return;
        }
    }

    private void handleGraphicsError(Exception exception) {
        RAS.logException(19, 17, this, "handleGraphicsError", exception);
        1 var2_2 = new 1();
        ConfirmationBox confirmationBox = new ConfirmationBox(this.jdmNetUBrowser.getFrame(), jdmNetUBundle.getString("ConfirmationBox Title"), jdmNetUBundle.getString("GraphicError"), var2_2);
        confirmationBox.show();
    }

    void determineAllSlots() {
        new Vector();
        this.statusIcon = new Icon(this.jdmNetUBrowser.imageFrom((Object)this, "statusAnimation.gif"));
        this.statusIcon.setFlyOver(new GraphicFlyOver(jdmNetUBundle.getString("RetrievingStatus")));
        this.jdmNetUBrowser.addTrayIcon(this.statusIcon);
        try {
            this.interfaceModel = (GenModel)this.jdmNetUmodel.getComponent("Interface");
            StatusPipeNetUImpl statusPipeNetUImpl = new StatusPipeNetUImpl(this);
            FastNetUModel fastNetUModel = (FastNetUModel)this.jdmNetUmodel.getComponent("HandCodedFastNetU");
            Integer n = fastNetUModel.getDeviceGraphicInfo(statusPipeNetUImpl);
            statusPipeNetUImpl.dispose();
            if (n.intValue() != this.statusIndexes.size()) {
                throw new RemoteException();
            }
            this.showSlotContainer();
        }
        catch (Exception exception) {
            this.handleGraphicsError(exception);
        }
        this.jdmNetUBrowser.removeTrayIcon(this.statusIcon);
        this.statusIcon.getImage().flush();
        this.statusIcon = null;
    }

    protected Thread getReCheckStatusThread() {
        return this.reCheckStatus;
    }

    protected void setReCheckStatusThread(Thread thread) {
        this.reCheckStatus = thread;
    }

    int mapInterfaceSlotType(int n, long l) {
        int n2 = 0;
        switch (n) {
            case 37: {
                n2 = 11;
                break;
            }
            case 9: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 33: {
                n2 = 7;
                break;
            }
            case 45: 
            case 65: {
                n2 = 8;
                break;
            }
            case 73: {
                n2 = 12;
                break;
            }
            case 15: {
                n2 = 13;
                break;
            }
            case 46: {
                n2 = 15;
                break;
            }
            case 70: {
                n2 = 17;
                break;
            }
            case 62: {
                n2 = 16;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    int mapPciSlotType(int n) {
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n2 = 10;
                break;
            }
            case 5: {
                n2 = 11;
                break;
            }
            case 7: {
                n2 = 3;
                break;
            }
            case 14: {
                n2 = 2;
                break;
            }
            case 13: {
                n2 = 6;
                break;
            }
            case 11: {
                n2 = 7;
                break;
            }
            case 12: {
                n2 = 8;
                break;
            }
            case 8: {
                n2 = 12;
                break;
            }
            case 17: {
                n2 = 13;
                break;
            }
            case 16: {
                n2 = 15;
                break;
            }
            case 15: {
                n2 = 16;
                break;
            }
            case 20: {
                n2 = 17;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    protected void setJdmNetUModel(GenModel genModel) {
        this.jdmNetUmodel = genModel;
    }

    protected void setPciAdapInfo(ModelInfo modelInfo) {
        this.pciAdapInfo = modelInfo;
    }

    class GraphicsThread
    extends Thread {
        private int RASID = 19;
        private int RASSUB = 17;
        GenModel ibmNetUGraphicModel;

        public GraphicsThread(GenModel genModel) {
            BoxGraphic.this = BoxGraphic.this;
            this.ibmNetUGraphicModel = genModel;
        }

        public void run() {
            if (BoxGraphic.this.jdmNetUBrowser != null && BoxGraphic.this.jdmNetUBrowser.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            this.setPriority(this.getPriority() + 1);
            BoxGraphic.this.predetermineAllSlots();
            if (this.ibmNetUGraphicModel == null || BoxGraphic.this.getSlotTypes() == null) {
                BoxGraphic.this.determineAllSlots();
                return;
            }
            BoxGraphic.this.attachStatusAndAction(this.ibmNetUGraphicModel);
        }
    }

    class StatusAttachThread
    extends Thread {
        DeviceGraphicInfo devInfo;

        public StatusAttachThread(DeviceGraphicInfo deviceGraphicInfo) {
            BoxGraphic.this = BoxGraphic.this;
            this.devInfo = deviceGraphicInfo;
        }

        public void run() {
            if (BoxGraphic.this.jdmNetUBrowser != null && BoxGraphic.this.jdmNetUBrowser.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            BoxGraphic.this.processOne(this.devInfo);
        }
    }

    class IbmNetUGraphicAttachThread
    extends Thread {
        ModelInfo info;

        public IbmNetUGraphicAttachThread(ModelInfo modelInfo) {
            BoxGraphic.this = BoxGraphic.this;
            this.info = modelInfo;
        }

        public void run() {
            if (BoxGraphic.this.jdmNetUBrowser != null && BoxGraphic.this.jdmNetUBrowser.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            BoxGraphic.this.ibmNetUGraphicAttach(this.info);
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BoxGraphic.this.doGraphicsThread();
        }

        /* synthetic */ 1() {
        }
    }
}

